<?php

// every 5 minutes, send /POST data to API

add_action( 'canary__cron_postdata__hook', 'canary__cron_postdata__callback' );
function canary__cron_postdata__callback (){

	$data = canary__generate_data();

	$options = [
		'http' => [
			'method' => 'POST',
			'header' => 'Content-Type: application/json',
			'content' => wp_json_encode( $data ),
		],
	];

	$context = stream_context_create( $options );
	$response = json_decode( file_get_contents( CANARY__API_URL . '/reports', false, $context ), true );

	if ( isset( $response['error'] ) ) {
		return canary__log( 'Failed to post data to API: ' . $response['error'] );
	}

	canary__log( 'Data posted to API,' . $response );
	return ;

}

if ( ! wp_next_scheduled( 'canary__cron_postdata__hook' ) ) {
    wp_schedule_event( time(), 'canary__interval__5_minutes', 'canary__cron_postdata__hook' );
}