<?php

// function call by inc/cron_postdata.php and inc/endpoint__infos__get.php
// ie the /POST and /GET endpoints produce similar data

function canary__generate_data(){

	if ( ! function_exists( 'get_plugin_data' ) ){
		require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
	}

	$plugins = array_map(
		function( $plugin ) {
			return get_plugin_data( WP_PLUGIN_DIR . '/' . $plugin );
		},
		get_option( 'active_plugins' )
	);

	$plugins_filtered = array_map(
		function( $plugin ){
			return array(
				'name'		=> $plugin['Name'],
				'version'	=> $plugin['Version']
			);
		},
		$plugins
	);

	$data = array(
		'sourceType'		=> 'wordpress',
		'GET'				=> get_rest_url(null, 'canary/v1/infos/'),
		'name'				=> get_bloginfo( 'name' ),
		'phpVersion'		=> phpversion(),
		'wpVersion'			=> get_bloginfo( 'version' ),
		'admin'				=> get_bloginfo( 'admin_email' ),
		'wpUrl'				=> get_bloginfo( 'wpurl' ),
		'plugins'			=> $plugins_filtered,
	);

	return $data;

}