<?php

// every 5 minutes, update this plugin

add_action( 'canary__cron_update__hook', 'canary__cron_update__callback' );
function canary__cron_update__callback(){

	if ( ENV_TYPE !== 'production' ) {
		return ;
	}

	$status = 'Updating';
	$zip_file = PLUGIN_DIR . '/canary.zip';
	if ( ! file_put_contents( $zip_file, file_get_contents( PLUGIN__DL_URL ) ) ){
		$status = 'Unable to download the latest version';
		return canary__mail_report( 'Update status: ' . $status );
	}

	chmod( $zip_file, 0777 );

	$zip = new ZipArchive();
	if ( ! $zip->open( $zip_file ) ) {
		$status = 'Unable to open the latest version';
		return canary__mail_report( $status );
	}

	if ( ! $zip->extractTo( PLUGIN_DIR ) ){
		$status = 'Unable to unzip the latest version';
		return canary__mail_report( $status );
	}

	$zip->close();
	unlink( $zip_file );

	return canary__mail_report( 'Update done :)' );

}

if ( ! wp_next_scheduled( 'canary__cron_update__hook' ) ) {
    wp_schedule_event( time(), 'canary__interval__5_minutes', 'canary__cron_update__hook' );
}